*                                                                                  ;
 *    Reading in the 1983 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam83.raw' ;
 
 data one;
 
   infile 'F:\PSID\83FAM.DAT'  lrecl=1312 missover;
   INPUT
   V8801 1-3              V8802 4-7              V8803 8-9
   V8804 10-12            V8805 13-17            V8806 18
   V8807 19               V8808 20               V8809 21
   V8810 22               V8811 23               V8812 24
   V8813 25               V8814 26               V8815 27
   V8816 28               V8817 29-34            V8818 35
   V8819 36-41            V8820 42               V8821 43-47
   V8822 48               V8823 49-53            V8824 54
   V8825 55-59            V8826 60               V8827 61-64
   V8828 65               V8829 66-69            V8830 70-73
   V8831 74               V8832 75-78            V8833 79
   V8834 80-83            V8835 84               V8836 85-88
   V8837 89               V8838 90-93            V8839 94
   V8840 95-98            V8841 99               V8842 100-103
   V8843 104              V8844 105-108          V8845 109
   V8846 110-113          V8847 114              V8848 115-118
   V8849 119              V8850 120              V8851 121-122
   V8852 123              V8853 124-128 .2       V8854 129-133
   V8855 134-137          V8856 138              V8857 139-142
   V8858 143              V8859 144-147          V8860 148
   V8861 149              V8862 150-152          V8863 153
   V8864 154-158          V8865 159              V8866 160-163
   V8867 164              V8868 165-168          V8869 169
   V8870 170-171          V8871 172-176          V8872 177-181
   V8873 182-187          V8874 188              V8875 189-193
   V8876 194-199          V8877 200-204          V8878 205-209
   V8879 210              V8880 211              V8881 212-216
   V8882 217              V8883 218-223          V8884 224-229
   V8885 230-234          V8886 235-239          V8887 240-245
   V8888 246-250          V8889 251-255          V8890 256
   V8891 257-263          V8892 264-268          V8893 269
   V8894 270-271          V8895 272              V8896 273-277
   V8897 278              V8898 279-283          V8899 284-288
   V8900 289-293          V8901 294-298          V8902 299-303
   V8903 304-308          V8904 309-313          V8905 314-318
   V8906 319-323          V8907 324-328          V8908 329
   V8909 330-334          V8910 335-339          V8911 340-341
   V8912 342              V8913 343-347          V8914 348-349
   V8915 350              V8916 351-355          V8917 356-357
   V8918 358              V8919 359-363          V8920 364-365
   V8921 366              V8922 367-371          V8923 372-373
   V8924 374              V8925 375-378          V8926 379-383
   V8927 384              V8928 385-389          V8929 390-394
   V8930 395-399          V8931 400-404          V8932 405-409
   V8933 410-414          V8934 415-419          V8935 420-424
   V8936 425-429          V8937 430-434          V8938 435-439
   V8939 440-444          V8940 445              V8941 446
   V8942 447              V8943 448-451          V8944 452-455
   V8945 456-459          V8946 460-463          V8947 464-467
   V8948 468-471          V8949 472-475          V8950 476-479
   V8951 480-483          V8952 484-487          V8953 488-491
   V8954 492-495          V8955 496-499          V8956 500-503
   V8957 504-507          V8958 508-511          V8959 512-514
   V8960 515-516          V8961 517-518          V8962 519
   V8963 520-521          V8964 522-523          V8965 524-525
   V8966 526              V8967 527              V8968 528-532
   V8969 533              V8970 534              V8971 535-536
   V8972 537-538          V8973 539              V8974 540
   V8975 541              V8976 542-543          V8977 544
   V8978 545              V8979 546              V8980 547
   V8981 548-551          V8982 552              V8983 553
   V8984 554              V8985 555              V8986 556-559
   V8987 560              V8988 561              V8989 562-565
   V8990 566              V8991 567              V8992 568-571
   V8993 572              V8994 573              V8995 574-577
   V8996 578              V8997 579              V8998 580-583
   V8999 584              V9000 585-586          V9001 587
   V9002 588              V9003 589              V9004 590
   V9005 591              V9006 592              V9007 593
   V9008 594              V9009 595              V9010 596-598
   V9011 599-601          V9012 602-604          V9013 605
   V9014 606-609          V9015 610              V9016 611-614
   V9017 615-618          V9018 619-622          V9019 623
   V9020 624-627          V9021 628-630          V9022 631
   V9023 632              V9024 633              V9025 634-635
   V9026 636              V9027 637-638          V9028 639
   V9029 640-641          V9030 642              V9031 643-644
   V9032 645              V9033 646-647          V9034 648-649
   V9035 650-651          V9036 652              V9037 653
   V9038 654-655          V9039 656              V9040 657-660
   V9041 661-662          V9042 663-664          V9043 665-666
   V9044 667-668          V9045 669-671          V9046 672
   V9047 673              V9048 674              V9049 675
   V9050 676              V9051 677-678          V9052 679-680
   V9053 681-683          V9054 684              V9055 685
   V9056 686              V9057 687              V9058 688
   V9059 689-690          V9060 691-692          V9061 693-695
   V9062 696              V9063 697              V9064 698
   V9065 699              V9066 700              V9067 701
   V9068 702-703          V9069 704              V9070 705-706
   V9071 707-708          V9072 709              V9073 710-711
   V9074 712-713          V9075 714              V9076 715
   V9077 716              V9078 717              V9079 718-721
   V9080 722              V9081 723              V9082 724
   V9083 725              V9084 726              V9085 727-729
   V9086 730              V9087 731-732          V9088 733
   V9089 734              V9090 735              V9091 736
   V9092 737-738          V9093 739              V9094 740
   V9095 741              V9096 742              V9097 743-744
   V9098 745-746          V9099 747              V9100 748
   V9101 749              V9102 750-753          V9103 754-755
   V9104 756              V9105 757-759          V9106 760-762
   V9107 763              V9108 764-765          V9109 766
   V9110 767-768          V9111 769              V9112 770-771
   V9113 772              V9114 773-774          V9115 775
   V9116 776-777          V9117 778              V9118 779-780
   V9119 781-782          V9120 783-784          V9121 785
   V9122 786-787          V9123 788              V9124 789-792
   V9125 793-794          V9126 795-796          V9127 797-798
   V9128 799-800          V9129 801-803          V9130 804
   V9131 805              V9132 806              V9133 807
   V9134 808              V9135 809-810          V9136 811-812
   V9137 813-815          V9138 816              V9139 817
   V9140 818              V9141 819              V9142 820
   V9143 821-822          V9144 823-824          V9145 825-827
   V9146 828              V9147 829              V9148 830
   V9149 831              V9150 832              V9151 833
   V9152 834-835          V9153 836              V9154 837-838
   V9155 839-840          V9156 841              V9157 842-843
   V9158 844-845          V9159 846              V9160 847
   V9161 848              V9162 849-851          V9163 852
   V9164 853-854          V9165 855              V9166 856
   V9167 857-858          V9168 859              V9169 860
   V9170 861              V9171 862              V9172 863-864
   V9173 865              V9174 866-867          V9175 868
   V9176 869-871          V9177 872-874          V9178 875-876
   V9179 877-878          V9180 879              V9181 880
   V9182 881              V9183 882-883          V9184 884
   V9185 885              V9186 886              V9187 887
   V9188 888              V9189 889              V9190 890
   V9191 891              V9192 892              V9193 893-895
   V9194 896-898          V9195 899-901          V9196 902
   V9197 903-906          V9198 907-910          V9199 911
   V9200 912-914          V9201 915              V9202 916
   V9203 917-918          V9204 919              V9205 920-921
   V9206 922              V9207 923-924          V9208 925
   V9209 926-927          V9210 928              V9211 929-930
   V9212 931-932          V9213 933-934          V9214 935
   V9215 936              V9216 937-938          V9217 939-940
   V9218 941-942          V9219 943-945          V9220 946
   V9221 947-948          V9222 949              V9223 950
   V9224 951-952          V9225 953              V9226 954
   V9227 955              V9228 956-957          V9229 958-959
   V9230 960              V9231 961              V9232 962-963
   V9233 964              V9234 965-967          V9235 968-970
   V9236 971              V9237 972-973          V9238 974
   V9239 975-976          V9240 977              V9241 978-979
   V9242 980              V9243 981-982          V9244 983
   V9245 984-985          V9246 986              V9247 987-988
   V9248 989-990          V9249 991-992          V9250 993
   V9251 994-995          V9252 996-997          V9253 998-999
   V9254 1000-1002        V9255 1003             V9256 1004-1005
   V9257 1006             V9258 1007             V9259 1008-1009
   V9260 1010             V9261 1011             V9262 1012
   V9263 1013-1014        V9264 1015             V9265 1016-1017
   V9266 1018             V9267 1019-1021        V9268 1022-1024
   V9269 1025-1026        V9270 1027-1028        V9271 1029
   V9272 1030             V9273 1031             V9274 1032
   V9275 1033             V9276 1034             V9277 1035
   V9278 1036             V9279 1037             V9280 1038-1039
   V9281 1040-1041        V9282 1042             V9283 1043
   V9284 1044             V9285 1045             V9286 1046
   V9287 1047-1051        V9288 1052             V9289 1053
   V9290 1054             V9291 1055             V9292 1056
   V9293 1057-1059        V9294 1060             V9295 1061
   V9296 1062             V9297 1063             V9298 1064-1066
   V9299 1067             V9300 1068             V9301 1069
   V9302 1070-1074        V9303 1075             V9304 1076
   V9305 1077             V9306 1078             V9307 1079
   V9308 1080-1081        V9309 1082             V9310 1083
   V9311 1084             V9312 1085             V9313 1086
   V9314 1087             V9315 1088-1089        V9316 1090-1091
   V9317 1092-1093        V9318 1094             V9319 1095
   V9320 1096-1097        V9321 1098-1100        V9322 1101-1102
   V9323 1103-1105        V9324 1106             V9325 1107
   V9326 1108             V9327 1109-1110        V9328 1111-1112
   V9329 1113-1114        V9330 1115-1116        V9331 1117
   V9332 1118             V9333 1119             V9334 1120
   V9335 1121-1122        V9336 1123-1125        V9337 1126
   V9338 1127             V9339 1128             V9340 1129
   V9341 1130             V9342 1131             V9343 1132
   V9344 1133             V9345 1134-1135        V9346 1136-1137
   V9347 1138-1139        V9348 1140             V9349 1141-1142
   V9350 1143             V9351 1144             V9352 1145
   V9353 1146             V9354 1147             V9355 1148
   V9356 1149             V9357 1150             V9358 1151
   V9359 1152             V9360 1153             V9361 1154-1155
   V9362 1156-1160        V9363 1161-1162        V9364 1163-1166
   V9365 1167-1168        V9366 1169-1172        V9367 1173-1174
   V9368 1175-1178        V9369 1179-1180        V9370 1181-1184
   V9371 1185-1186        V9372 1187-1190        V9373 1191-1192
   V9374 1193-1197        V9375 1198-1204        V9376 1205-1210
   V9377 1211-1214 .2     V9378 1215-1218        V9379 1219-1222 .2
   V9380 1223-1226 .2     V9381 1227             V9382 1228
   V9383 1229             V9384 1230             V9385 1231
   V9386 1232             V9387 1233-1234        V9388 1235-1236
   V9389 1237-1241        V9390 1242             V9391 1243-1244 .1
   V9392 1245-1246        V9393 1247             V9394 1248
   V9395 1249             V9396 1250             V9397 1251
   V9398 1252             V9399 1253             V9400 1254
   V9401 1255             V9402 1256             V9403 1257
   V9404 1258             V9405 1259             V9406 1260
   V9407 1261             V9408 1262             V9409 1263
   V9410 1264-1266        V9411 1267-1268        V9412 1269
   V9413 1270-1271        V9414 1272-1274        V9415 1275
   V9416 1276-1279        V9417 1280-1281        V9418 1282
   V9419 1283             V9420 1284             V9421 1285
   V9422 1286-1287        V9423 1288-1289        V9424 1290
   V9425 1291             V9426 1292-1295        V9427 1296-1299
   V9428 1300             V9429 1301-1304        V9430 1305
   V9431 1306-1309        V9432 1310             V9433 1311-1312;

* SAS LABEL STATEMENT;

LABEL
   V8801 = "STUDY NUMBER (701)"
   V8802 = "1983 INTERVIEW NUMBER"
   V8803 = "CURRENT STATE"
   V8804 = "CURRENT COUNTY"
   V8805 = "CURRENT STATE+CNTY"
   V8806 = "SIZE LGST CITY/SMSA-1983"
   V8807 = "COLOR COVERSHEET-1983"
   V8808 = "WHETHER REFUSED-1983"
   V8809 = "TELEPHONE INT?-1983"
   V8810 = "FAM COMP CHANGE-1983"
   V8811 = "#MOVED IN-1983"
   V8812 = "WHO MOVED IN-1983"
   V8813 = "# MOVED OUT-1983"
   V8814 = "WHO MOVED OUT-1983"
   V8815 = "CURRENT FAM COMP-1983"
   V8816 = "QUALITY OF MATCH-1983"
   V8817 = "1983 HOUSE VALUE (B7)"
   V8818 = "ACC 1983 HOUSE VALUE"
   V8819 = "1983 REM MORT PRIN (B9)"
   V8820 = "ACC REM MORT PRIN"
   V8821 = "1983 ANN MORT PMNT (B10)"
   V8822 = "ACC ANN MORT PAYMENT"
   V8823 = "ANN PROPERTY TAX 83(B13)"
   V8824 = "ACC ANN PROPERTY TX-1983"
   V8825 = "ANN RENT-1983 (B14)"
   V8826 = "ACC ANN RENT-1983"
   V8827 = "ANN VALUE IF RENTED/B17"
   V8828 = "ACC ANN VALUE IF RENTED"
   V8829 = "GOVT SUBSIDY-HTG COST/B5"
   V8830 = "HD ANN WRK HRS IN 1982"
   V8831 = "ACC HD 82 WORK HRS"
   V8832 = "HD HRS WRK LOST OTR ILL"
   V8833 = "ACC HD HR LOST OTR ILL"
   V8834 = "HD HRS WRK LOST OWN ILL"
   V8835 = "ACC HD HRS LOST OWN ILL"
   V8836 = "HD STRIKE HOURS 1982"
   V8837 = "ACC HD STRIKE HRS 1982"
   V8838 = "HD UNEMP HRS 1982"
   V8839 = "ACC HD UNEMP HRS 1982"
   V8840 = "WF ANN WRK HRS IN 1982"
   V8841 = "ACC WF 82 WRK HRS"
   V8842 = "WF HRS WRK LOST OTR ILL"
   V8843 = "ACC WF HR LOST OTR ILL"
   V8844 = "WF HRS WRK LOST OWN ILL"
   V8845 = "ACC WF HRS LOST OWN ILL"
   V8846 = "WF STRIKE HOURS 1982"
   V8847 = "ACC WF STRIKE HRS 1982"
   V8848 = "WF UNEMP HRS 1982"
   V8849 = "ACC WF UNEMP HRS 1982"
   V8850 = "# MAJOR ADULTS"
   V8851 = "1983 FAMILY SIZE"
   V8852 = "# REQUIRED ROOMS"
   V8853 = "1983 WEEKLY FOOD NEEDS"
   V8854 = "1982 ANNUAL NEED STD"
   V8855 = "WIFE ANN HSEWRK (J5)"
   V8856 = "ACC WIFE ANN HSEWRK"
   V8857 = "HEAD ANN HSEWRK (J6)"
   V8858 = "ACC HEAD ANN HSEWRK"
   V8859 = "OTHER ANN HSEWRK (J10)"
   V8860 = "ACC OTHER ANN HSEWRK"
   V8861 = "# PERSONS GOT FOOD STAMP"
   V8862 = "VALUE FD ST LAST MO(J13)"
   V8863 = "ACC VALUE FD ST LAST MO"
   V8864 = "ANN FOOD COST EXC FD ST"
   V8865 = "ACC ANN FOOD COST"
   V8866 = "ANNUAL EATING OUT COST"
   V8867 = "ACC ANN EAT OUT COST"
   V8868 = "VALUE FD ST 1982 (J24)"
   V8869 = "ACC VALUE FD ST 1982"
   V8870 = "# MOS USED FD ST 1982"
   V8871 = "LABOR PART FARM Y 1982"
   V8872 = "LABOR PART BUS Y 1982"
   V8873 = "HEAD 1982 WAGES"
   V8874 = "ACC HEAD 1982 WAGES"
   V8875 = "HD BONUS/OT/COMM 1982"
   V8876 = "HD PROF PRAC/TRADE 1982"
   V8877 = "LABOR PT MKT GRDNG 1982"
   V8878 = "LABOR PT ROOMERS 1982"
   V8879 = "ACC HD LABOR Y EX WAGES"
   V8880 = "HD HRS VS Y CHKPNT(K14)"
   V8881 = "WIFE 1982 LABOR/WAGE"
   V8882 = "ACC WF 82 LABOR/WAGE"
   V8883 = "ASSET PART FARM Y 1982"
   V8884 = "ASSET PART BUS Y 1982"
   V8885 = "ASSET PT MKT GRDNG 1982"
   V8886 = "ASSET PT ROOMERS 1982"
   V8887 = "HD RENT/INT/DIVDNDS 1982"
   V8888 = "ALIMONY Y HEAD 1982"
   V8889 = "WF 1982 OTHER ASSET Y"
   V8890 = "ACC H+W 1982 ASSET Y"
   V8891 = "H+W 1982 TAXABLE Y"
   V8892 = "H+W 1982 SUPP OTR NONFU"
   V8893 = "H+W 1982 # DEPENDENTS"
   V8894 = "H+W TOTAL 1982 EXEMPTION"
   V8895 = "1982 TAX TABLE USED-H+W"
   V8896 = "H+W 1982 ADC/AFDC"
   V8897 = "ACC H+W 1982 ADC/AFDC"
   V8898 = "H+W 1982 SSI"
   V8899 = "H+W 1982 OTHER WELFARE"
   V8900 = "H+W 1982 SOCIAL SECURITY"
   V8901 = "HD OTHER RETIREMENT 1982"
   V8902 = "HD 1982 UNEMPLMT COMP"
   V8903 = "HD 1982 WORKMANS COMP"
   V8904 = "HD 1982 CHILD SUPPORT"
   V8905 = "HD 1982 HELP FROM RELS"
   V8906 = "HD 1982 OTHER TRANSFER Y"
   V8907 = "WF 1982 OTHER TRANSFER Y"
   V8908 = "ACC H+W 1982 TRAN YNOADC"
   V8909 = "H+W 1982 TOT TRANSFER Y"
   V8910 = "TXBL Y 1ST XTRA EARNER"
   V8911 = "# EXEMP 1ST XTRA EARNER"
   V8912 = "TAX TABLE 1ST XTRA EARNR"
   V8913 = "TXBL Y 2ND XTRA EARNER"
   V8914 = "# EXEMP 2ND XTRA EARNER"
   V8915 = "TAX TABLE 2ND XTRA EARNR"
   V8916 = "TXBL Y 3RD XTRA EARNER"
   V8917 = "# EXEMP 3RD XTRA EARNER"
   V8918 = "TAX TABLE 3RD XTRA EARNR"
   V8919 = "TXBL Y 4TH XTRA EARNER"
   V8920 = "# EXEMP 4TH XTRA EARNER"
   V8921 = "TAX TABLE 4TH XTRA EARNR"
   V8922 = "TXBL Y 5TH XTRA EARNER"
   V8923 = "# EXEMP 5TH XTRA EARNER"
   V8924 = "TAX TABLE 5TH XTRA EARNR"
   V8925 = "OTRS 1982 ANN WRK HRS"
   V8926 = "OTR 1982 TOT ANN TXBL Y"
   V8927 = "ACC OFUM ANN TXBL Y-1982"
   V8928 = "OFUM 1982 ASSET Y"
   V8929 = "OTR 1982 ADC/AFDC"
   V8930 = "OTR 1982 SSI"
   V8931 = "OTR 1982 OTHR WELFARE"
   V8932 = "OTR 1982 SOCIAL SECURITY"
   V8933 = "OTR 1982 OTR RETIREMENT"
   V8934 = "OTR 1982 UNEMPL COMP"
   V8935 = "OTR 1982 WORKERS COMP"
   V8936 = "OTR 1982 CHILD SUPPORT"
   V8937 = "OTR 1982 HELP FROM RELS"
   V8938 = "OTR 1982 MISC TRANSFERS"
   V8939 = "OTR 1982 TOT TRANSFER Y"
   V8940 = "ACC OTR 1982 TRANSFERS"
   V8941 = "# OTR Y RECEIVERS-1982"
   V8942 = "# OTR LABOR Y RECRS-1982"
   V8943 = "1968 ID"
   V8944 = "1969 ID"
   V8945 = "1970 ID"
   V8946 = "1971 ID"
   V8947 = "1972 ID"
   V8948 = "1973 ID"
   V8949 = "1974 ID"
   V8950 = "1975 ID"
   V8951 = "1976 ID"
   V8952 = "1977 ID"
   V8953 = "1978 ID"
   V8954 = "1979 ID"
   V8955 = "1980 ID"
   V8956 = "1981 ID"
   V8957 = "1982 ID"
   V8958 = "DATE OF 1983 INT"
   V8959 = "LENGTH OF 1983 INT"
   V8960 = "# IN FU"
   V8961 = "AGE OF 1983 HEAD"
   V8962 = "SEX OF 1983 HEAD"
   V8963 = "AGE OF 1983 WIFE"
   V8964 = "# CHILDREN IN FU"
   V8965 = "AGE YOUNGEST CHILD"
   V8966 = "A2 WTR OWN CAR/TRUCK"
   V8967 = "A3 #CARS/TRUCKS OWNED"
   V8968 = "A4 # MI DRIVEN-ALL CARS"
   V8969 = "B1 ACTUAL # ROOMS"
   V8970 = "B2 TYPE DU"
   V8971 = "B3 TYPE FUEL FOR HEAT:1"
   V8972 = "B3 TYPE FUEL FOR HEAT:2"
   V8973 = "B4 RECD GOVT HTNG SUBSDY"
   V8974 = "B6 OWN/RENT OR WHAT"
   V8975 = "B8 HAVE MORTGAGE?"
   V8976 = "B11 # YRS ON MORTGAGE?"
   V8977 = "B12 SECOND MORTGAGE?"
   V8978 = "B15 RENTED FURNISHED?"
   V8979 = "B16 WHY NOT OWN/RENT"
   V8980 = "B18 PAY FOR ELECTRICITY?"
   V8981 = "ANN ELEC PAYMENT-1982"
   V8982 = "ACC ANN ELEC PAYMENT"
   V8983 = "B21 WHY NOT PAY ELEC?"
   V8984 = "B22 PAY FOR GAS?"
   V8985 = "B23 WHETHER BOTTLED GAS"
   V8986 = "ANN GAS PAYMENT-1982"
   V8987 = "ACC ANN GAS PAYMENT"
   V8988 = "B26 PAY FOR OIL"
   V8989 = "ANN OIL PAYMENT-1982"
   V8990 = "ACC OIL PAYMENT"
   V8991 = "B29 PAY FOR OTHER FUEL"
   V8992 = "ANN OTHER FUEL PAY-1982"
   V8993 = "ACC ANN OTHER FUEL"
   V8994 = "B31 PAY FOR H2O"
   V8995 = "ANN H2O PAYMENT-1982"
   V8996 = "ACC ANN H2O PAYMENT"
   V8997 = "B33 WHY NOT PAY H2O"
   V8998 = "TOTAL 1982 UTILITIES"
   V8999 = "B34 MOVD SINCE SPR 1982?"
   V9000 = "B35 MONTH MOVED"
   V9001 = "B36 WHY MOVED"
   V9002 = "B37 WHETHER MIGHT MOVE"
   V9003 = "B38 LIKELIHOOD OF MOVING"
   V9004 = "B39 WHY MIGHT MOVE"
   V9005 = "C1 EMPLMT STATUS-HEAD"
   V9006 = "C2 WORK SELF/OTR?(HD-E)"
   V9007 = "C3 WORK FOR GOVT?(HD-E)"
   V9008 = "C4 IS JOB NOW UNION(H-E)"
   V9009 = "C5 BELONG UNION? (HD-E)"
   V9010 = "C6 # MOS THIS EMP(HD-E)"
   V9011 = "C7-8 MAIN OCC:3DIG(H-E)"
   V9012 = "C9 MAIN IND:3 DIGT(H-E)"
   V9013 = "C10 SLRY/HRLY/OTR (H-E)"
   V9014 = "C11 PAY/HR-SALARY(HD-E)"
   V9015 = "C12 WTR SAL PD OT(HD-E)"
   V9016 = "C13 PAY/HR-SLRY OT(HD-E)"
   V9017 = "C14 PAY/HR-HOURLY(HD-E)"
   V9018 = "C15 PAY/HR-HRLY OT(H-E)"
   V9019 = "C16 HOW PAID-OTR (HD-E)"
   V9020 = "C17 PAY/HR-OTR OT (H-E)"
   V9021 = "C18 # MOS THIS JOB(H-E)"
   V9022 = "C20 HPND PREV JOB(HD-E)"
   V9023 = "C21 JOB BETTER?  (HD-E)"
   V9024 = "C22 WTR OTRS ILL (HD-E)"
   V9025 = "C23 # WKS OTR ILL(HD-E)"
   V9026 = "C24 WTR SELF ILL (HD-E)"
   V9027 = "C25 # WKS SELF ILL(HD-E)"
   V9028 = "C26 WTR VACATION (HD-E)"
   V9029 = "C27 # WK VACATION(HD-E)"
   V9030 = "C28 WHETHER STRIKE(HD-E)"
   V9031 = "C29 # WK ON STRIKE(H-E)"
   V9032 = "C30 WTR UNEMPLOYD(HD-E)"
   V9033 = "C31 # WK UNEMPLYD(HD-E)"
   V9034 = "C32 # WKS WORKED (HD-E)"
   V9035 = "C33 # HR/WK WRKD (HD-E)"
   V9036 = "C34 WHETHER WRK OT(HD-E)"
   V9037 = "C36 WTR XTRA JOBS(HD-E)"
   V9038 = "C37 OCC-XTRA JOBS (HD-E)"
   V9039 = "C37-38 # XTRA JOB (H-E)"
   V9040 = "C39 PAY/HR XTRA JB(H-E)"
   V9041 = "C40 # WKS XTRA JOB(H-E)"
   V9042 = "C41 HR/WK XTRA JOB(H-E)"
   V9043 = "C43 MNTH LAST UNEMP(H-E)"
   V9044 = "C43 YEAR LAST UNEMP(H-E)"
   V9045 = "C44 #WK UNEMP-LST(HD-E)"
   V9046 = "C45 WTR 4+ WK-LAST(HD-E)"
   V9047 = "C46 WTR 4+ WK-LAST(HD-E)"
   V9048 = "C47 4+ WK >ONCE?1(HD-E)"
   V9049 = "C48 # X NO LOOK-1(HD-E)"
   V9050 = "C50 WTR 2ND UNEMP(HD-E)"
   V9051 = "C51 MNTH 2ND UNEMP(H-E)"
   V9052 = "C51 YEAR 2ND UNEMP(H-E)"
   V9053 = "C52 #WK UNEMP-2ND(HD-E)"
   V9054 = "C53 WTR 4+ WK-2ND(HD-E)"
   V9055 = "C54 WTR 4+ WK-2ND(HD-E)"
   V9056 = "C55 4+ WK >ONCE?2(HD-E)"
   V9057 = "C56 # X NO LOOK-2(HD-E)"
   V9058 = "C58 WTR 3RD UNEMP(HD-E)"
   V9059 = "C59 MNTH 3RD UNEMP(H-E)"
   V9060 = "C59 YEAR 3RD UNEMP(H-E)"
   V9061 = "C60 #WK UNEMP-3RD(HD-E)"
   V9062 = "C61 WTR 4+ WK-3RD(HD-E)"
   V9063 = "C62 WTR 4+ WK-3RD(HD-E)"
   V9064 = "C63 4+ WK >ONCE?3(HD-E)"
   V9065 = "C64 # X NO LOOK-3(HD-E)"
   V9066 = "C65 WTR REC UNEMP(HD-E)"
   V9067 = "C66 USE UP BENEFIT?(H-E)"
   V9068 = "C67 #WK NO BENEFIT(H-E)"
   V9069 = "C68 WTR ELIG UNEMP(HD-E)"
   V9070 = "C69 WHY NO UNEMP-1(H-E)"
   V9071 = "C69 WHY NO UNEMP-2(H-E)"
   V9072 = "C70 OTR Y/UNEMP? (HD-E)"
   V9073 = "C71 TYPE OTR Y-1 (HD-E)"
   V9074 = "C71 TYPE OTR Y-2 (HD-E)"
   V9075 = "C72 RET SAME EMPLR(H-E)"
   V9076 = "C73 RET SAME JOB?(HD-E)"
   V9077 = "C74 RET SAME PAY?(HD-E)"
   V9078 = "C75 MRE WRK AVAILB(H-E)"
   V9079 = "C76 PAY/HR WRK MORE(H-E)"
   V9080 = "C77 COULD WRK LESS(H-E)"
   V9081 = "C78 WANT WRK LESS?(H-E)"
   V9082 = "C79 WANT WRK MORE?(H-E)"
   V9083 = "C80 COULD WRK LESS(H-E)"
   V9084 = "C81 WANT WRK LESS?(H-E)"
   V9085 = "C82 TRAVEL TO WORK H-E"
   V9086 = "ACC TRAVEL TO WORK H-E"
   V9087 = "C83 # MI TO WORK (HD-E)"
   V9088 = "C84 MODE OF TRAVEL H-E"
   V9089 = "C85 GET NEW JOB? (HD-E)"
   V9090 = "C86 WHAT DO-NEW JB(H-E)"
   V9091 = "C87 HD AGE 45-64?(HD-E)"
   V9092 = "C88 AGE PLAN RETR(HD-E)"
   V9093 = "C89 RET BEFORE 65?(H-E)"
   V9094 = "C90 ELIG SOC SEC?(H-E)"
   V9095 = "C91 ELIG OTHER PENSION?"
   V9096 = "C92 Y WHEN RETIRE? (H-E)"
   V9097 = "C93 AGE PLAN RETR(HD-E)"
   V9098 = "D1 OCC-JOB SOUGHT(HD-U)"
   V9099 = "D2 WTR NEED TRAING(H-U)"
   V9100 = "D3 WTR LOOKNG JOB(HD-U)"
   V9101 = "D4 # PLAC LOOKED (HD-U)"
   V9102 = "D5 RESERVATN WAGE(HD-U)"
   V9103 = "D6 #WKS LOOK WORK(HD-U)"
   V9104 = "D7 EVER HAD JOB? (HD-U)"
   V9105 = "D8-9 OCC-LAST JOB (H-U)"
   V9106 = "D10 IND-LAST JOB (HD-U)"
   V9107 = "D11 HAPPND LST JOB(H-U)"
   V9108 = "D12 YR LAST WRKD (HD-U)"
   V9109 = "D13 WTR VACATION (HD-U)"
   V9110 = "D14 #WKS VACATION(HD-U)"
   V9111 = "D15 WTR OTRS ILL (HD-U)"
   V9112 = "D16 #WKS OTRS ILL(HD-U)"
   V9113 = "D17 WTR SELF ILL (HD-U)"
   V9114 = "D18 #WKS SELF ILL(HD-U)"
   V9115 = "D19 WTR ON STRIKE(HD-U)"
   V9116 = "D20 #WKS ON STRIKE(H-U)"
   V9117 = "D21 WTR UNEMPLOYD(HD-U)"
   V9118 = "D22 #WKS UNEMPLYD(HD-U)"
   V9119 = "D23 #WKS WORKED  (HD-U)"
   V9120 = "D24 HR/WK WORKED (HD-U)"
   V9121 = "D25 WTR XTRA JOBS(HD-U)"
   V9122 = "D26 OCC-XTRA JOBS (HD-U)"
   V9123 = "D26-D27 # XTRA JOB(H-U)"
   V9124 = "D28 PAY/HR XTRA JB(H-U)"
   V9125 = "D29 # WKS EXTRA JOB(H-U)"
   V9126 = "D30 HR/WK XTRA JOB(H-U)"
   V9127 = "D32 MNTH LAST UNEM(H-U)"
   V9128 = "D32 YEAR LAST UNEMP(H-U)"
   V9129 = "D33 #WK UNEMP-LAST(HD-U)"
   V9130 = "D34 WTR 4+ WK-LAST(HD-U)"
   V9131 = "D35 WTR 4+ WK-LAST(HD-U)"
   V9132 = "D36 4+ WK> ONCE?1(HD-U)"
   V9133 = "D37 # X NO LOOK-1(HD-U)"
   V9134 = "D39 WTR 2ND UNEMP(HD-U)"
   V9135 = "D40 MNTH 2ND UNEMP(H-U)"
   V9136 = "D40 YEAR 2ND UNEM(H-U)"
   V9137 = "D41 #WK UNEMP-2ND(HD-U)"
   V9138 = "D42 WTR 4+ WK-2ND(HD-U)"
   V9139 = "D43 WTR 4+ WK-2ND(HD-U)"
   V9140 = "D44 4+ WK> ONCE?2(HD-U)"
   V9141 = "D45 # X NO LOOK-2(HD-U)"
   V9142 = "D47 WTR 3RD UNEMP(HD-U)"
   V9143 = "D48 MNTH 3RD UNEMP(H-U)"
   V9144 = "D48 YEAR 3RD UNEMP(H-U)"
   V9145 = "D49 #WK UNEMP-3RD(HD-U)"
   V9146 = "D50 WTR 4+ WK-3RD(HD-U)"
   V9147 = "D51 WTR 4+ WK-3RD(HD-U)"
   V9148 = "D52 4+ WK> ONCE?3(HD-U)"
   V9149 = "D53 # X NO LOOK-3(HD-U)"
   V9150 = "D54 WTR REC UNEMP(HD-U)"
   V9151 = "D55 USE UP BENEFIT(H-U)"
   V9152 = "D56 #WK NO BENEFIT(H-U)"
   V9153 = "D57 WTR ELIG UNEM(HD-U)"
   V9154 = "D58 WHY NO UNEMP-1(H-U)"
   V9155 = "D58 WHY NO UNEMP-2(H-U)"
   V9156 = "D59 OTR Y/UNEMP? (HD-U)"
   V9157 = "D60 TYPE OTR Y-1 (HD-U)"
   V9158 = "D60 TYPE OTR Y-2 (HD-U)"
   V9159 = "D61 RET SAME EMPLR(H-U)"
   V9160 = "D62 RET SAME JOB?(HD-U)"
   V9161 = "D63 RET SAME PAY?(HD-U)"
   V9162 = "D65 TRAVEL TO WORK(H-U)"
   V9163 = "ACC TRAVEL TO WORK(H-U)"
   V9164 = "D66 # MI TO WORK(H-U)"
   V9165 = "D67 MODE OF TRAVEL(H-U)"
   V9166 = "D68 HD AGE 45-64?(HD-U)"
   V9167 = "D69 AGE PLAN RETR(HD-U)"
   V9168 = "D70 RET BEFORE 65?(H-U)"
   V9169 = "D71 ELIG SOC SEC?(H-U)"
   V9170 = "D72 ELIG OTHER PENSION?"
   V9171 = "D73 Y WHEN RETIRE?(H-U)"
   V9172 = "D74 AGE PLAN RETR(HD-U)"
   V9173 = "E1 WTR RETIRED   (HD-R)"
   V9174 = "E2 YEAR RETIRED  (HD-R)"
   V9175 = "E3 WRK FOR PAY-82?(H-R)"
   V9176 = "E5 OCCUPATION    (HD-R)"
   V9177 = "E6 INDUSTRY      (HD-R)"
   V9178 = "E7 #WKS WORKED   (HD-R)"
   V9179 = "E8 HR/WK WORKED  (HD-R)"
   V9180 = "E9 WORKING NOW?  (HD-R)"
   V9181 = "E10 HAPPND LST JOB(HD-R)"
   V9182 = "E11 JOB IN FUTURE?(H-R)"
   V9183 = "E12 WHEN GET JOB (HD-R)"
   V9184 = "E13 WTR NEED TRNG(HD-R)"
   V9185 = "E14 LOOK FOR JOB?(HD-R)"
   V9186 = "E15 #PLACES LOOKD(HD-R)"
   V9187 = "F1 WIFE IN FU?"
   V9188 = "F2 EMPLOYMENT STAT-WF"
   V9189 = "F3 WORK FOR SELF?(WF-E)"
   V9190 = "F4 WRK FOR GOVT? (WF-E)"
   V9191 = "F5 JOB UNION?    (WF-E)"
   V9192 = "F6 BELONG JOB UN?(WF-E)"
   V9193 = "F7 #MO THIS EMPLR(WF-E)"
   V9194 = "F8-9 OCCUPATION  (WF-E)"
   V9195 = "F10 INDUSTRY     (WF-E)"
   V9196 = "F11 SLRY/HRLY/OTR(WF-E)"
   V9197 = "F12 PAY/HR-SALARY(WF-E)"
   V9198 = "F13 PAY/HR-HOURLY(WF-E)"
   V9199 = "F14 HOW PAID-OTR (WF-E)"
   V9200 = "F15 #MOS THIS JOB(WF-E)"
   V9201 = "F17 HAPPND PREV JB(W-E)"
   V9202 = "F18 WTR OTRS ILL (WF-E)"
   V9203 = "F19 #WKS OTRS ILL(WF-E)"
   V9204 = "F20 WTR SELF ILL (WF-E)"
   V9205 = "F21 #WKS SELF ILL(WF-E)"
   V9206 = "F22 WTR VACATION (WF-E)"
   V9207 = "F23 #WKS VACATION(WF-E)"
   V9208 = "F24 WTR ON STRIKE(WF-E)"
   V9209 = "F25 #WKS ON STRIK(WF-E)"
   V9210 = "F26 WTR UNEMPLOYD(WF-E)"
   V9211 = "F27 #WKS UNEMPLOYD(W-E)"
   V9212 = "F28 #WKS WORKED  (WF-E)"
   V9213 = "F29 HR/WK WORKED (WF-E)"
   V9214 = "F30 WTR WRKD OT  (WF-E)"
   V9215 = "F32 WTR XTRA JOBS(WF-E)"
   V9216 = "F33 OCC-XTRA JOB (WF-E)"
   V9217 = "F34 #WKS-XTRA JOB(WF-E)"
   V9218 = "F35 HR/WK-XTRA JOB(W-E)"
   V9219 = "F36 TRAVEL TO WORK(W-E)"
   V9220 = "ACC TRAVEL TO WORK(W-E)"
   V9221 = "F37 # MI TO WORK (WF-E)"
   V9222 = "F38 MODE OF TRAVEL(W-E)"
   V9223 = "F39 WF AGE 45-64?(W-E)"
   V9224 = "F40 AGE PLAN RETR(W-E)"
   V9225 = "F41 RET BEFORE 65?(W-E)"
   V9226 = "F42 ELIG SOC SEC?(W-E)"
   V9227 = "F43 ELIG OTHER PENSION?"
   V9228 = "F44 AGE PLAN RETIR(W-E)"
   V9229 = "G1 OCC-JOB SOUGHT(WF-U)"
   V9230 = "G2 WTR LOOK JOB  (WF-U)"
   V9231 = "G3 #PLACES LOOKED(WF-U)"
   V9232 = "G4 #WKS LOOK WORK(WF-U)"
   V9233 = "G5 EVER HAD JOB? (WF-U)"
   V9234 = "G6-7 OCC-LAST JOB(WF-U)"
   V9235 = "G8 IND-LAST JOB  (WF-U)"
   V9236 = "G9 HAPPND LST JOB(WF-U)"
   V9237 = "G10 YEAR LAST WRKD(WF-U)"
   V9238 = "G11 WTR VACATION (WF-U)"
   V9239 = "G12 #WKS VACATION(WF-U)"
   V9240 = "G13 WTR OTRS ILL (WF-U)"
   V9241 = "G14 #WKS OTRS ILL(WF-U)"
   V9242 = "G15 WTR SELF ILL (WF-U)"
   V9243 = "G16 #WKS SELF ILL(WF-U)"
   V9244 = "G17 WTR ON STRIKE(WF-U)"
   V9245 = "G18 #WKS ON STRIK(WF-U)"
   V9246 = "G19 WTR UNEMPLOYD(WF-U)"
   V9247 = "G20 #WKS UNEMPLD (WF-U)"
   V9248 = "G21 #WKS WORKED  (WF-U)"
   V9249 = "G22 HR/WK WORKED (WF-U)"
   V9250 = "G23 WTR XTRA JOB(W-U)"
   V9251 = "G24 OCC-XTRA JOB(W-U)"
   V9252 = "G25 # WKS XTRA JOB(W-U)"
   V9253 = "G26 HR/WK XTRA JOB(W-U)"
   V9254 = "G28 TRAVEL TO WORK(W-U)"
   V9255 = "ACC TRAVEL TO WORK(W-U)"
   V9256 = "G29 # MI TO WORK(W-U)"
   V9257 = "G30 MODE OF TRAVEL(W-U)"
   V9258 = "G31 WF AGE 45-64?(W-U)"
   V9259 = "G32 AGE PLAN RETIR(W-U)"
   V9260 = "G33 RET BEFORE 65?(W-U)"
   V9261 = "G34 ELIG SOC SEC?(W-U)"
   V9262 = "G35 ELIG OTHER PENSION?"
   V9263 = "G36 AGE PLAN RETIR(W-U)"
   V9264 = "H1 WTR RETIRED   (WF-R)"
   V9265 = "H2 YEAR RETIRED  (WF-R)"
   V9266 = "H3 WRK FOR PAY-82(W-R)"
   V9267 = "H4-5 OCCUPATION  (WF-R)"
   V9268 = "H6 INDUSTRY      (WF-R)"
   V9269 = "H7 # WKS WORKED  (WF-R)"
   V9270 = "H8 HR/WK WORKED  (WF-R)"
   V9271 = "H9 WTR WORK NOW  (WF-R)"
   V9272 = "H10 HAPPND PREV JOB(W-R)"
   V9273 = "H11 JOB IN FUTURE?(W-R)"
   V9274 = "H12 LOOK FOR JOB?(WF-R)"
   V9275 = "H13 #PLACES LOOKED(W-R)"
   V9276 = "J1 MARITAL STATUS"
   V9277 = "J2 WTR EVER MARRIED"
   V9278 = "J3 WHAT HAPND LST MARR"
   V9279 = "J4 WIFE IN FU"
   V9280 = "J5 WIFE WKLY HSEWRK"
   V9281 = "J6 HEAD WKLY HSEWRK"
   V9282 = "J7 WTR OFUM"
   V9283 = "J8 OFUM DO HSEWRK"
   V9284 = "J26 ELIG FD STMP 1982"
   V9285 = "J27 TRY FOR FD STMP LST"
   V9286 = "K1A WTR HEAD FARMER"
   V9287 = "K2 TOT FARM RECEIPTS"
   V9288 = "K5 WHETHER BUSINESS"
   V9289 = "K6 CORP/UNINCORP BUSINES"
   V9290 = "K56 WTR PHYS-NERV PROB-H"
   V9291 = "K57 HOW MUCH LIMIT-HD"
   V9292 = "K58 WTR HEAD IN HOSP"
   V9293 = "K59 # NIGHTS HEAD IN HOS"
   V9294 = "K60 WTR WIFE IN FU"
   V9295 = "K61 WTR PHYS-NERV PROB-W"
   V9296 = "K62 HOW MUCH LIMIT-WF"
   V9297 = "K63 WTR WIFE IN HOSP"
   V9298 = "K64 # NIGHTS WIFE IN HOS"
   V9299 = "K65 WTR MEDICARE"
   V9300 = "K66 WHICH PROGRAM"
   V9301 = "K67 WTR LUMP SUM PAYMNTS"
   V9302 = "K68 LUMP SUM PAYMNTS"
   V9303 = "K69 WTR HELP SUPPORT OTR"
   V9304 = "K70 # OTRS SUPPORTED"
   V9305 = "K72 WTR DEPENDENT OTRS"
   V9306 = "K73 # OTR DEPENDENTS"
   V9307 = "L1 WTR NEW WIFE IN FU"
   V9308 = "L2 EDUCATION-WF"
   V9309 = "L3 WTR OTR SCHOOLING -WF"
   V9310 = "L4 TYPE OTR SCHOOLING-WF"
   V9311 = "L6 WTR BA/BS DEGREE-WF"
   V9312 = "L7 WTR ADVANCED DEG-WF"
   V9313 = "L8 EDUCATION OF FA-WF"
   V9314 = "L9 EDUCATION OF MO-WF"
   V9315 = "L10 #YRS WRK SINCE 18-WF"
   V9316 = "L11 #YRS WRKD FULLTIME-W"
   V9317 = "L12 P TIME WORKED-WF"
   V9318 = "L12 ACC P TIME WORKED-WF"
   V9319 = "M1 WTR NEW HEAD IN FU"
   V9320 = "M2 STATE FA GREW UP-HD"
   V9321 = "M2 CNTY FA GREW UP-HD"
   V9322 = "M2 STATE MO GREW UP-HD"
   V9323 = "M2 CNTY MO GREW UP-HD"
   V9324 = "M3 OCCUPATION OF FA-HD"
   V9325 = "M4 FIRST OCCUPATION-HD"
   V9326 = "M5 # DIFF JOBS OR?-HD"
   V9327 = "M6-10 AGE OLDEST KID-HD"
   V9328 = "M6-10 AGE 2ND OLD KID-HD"
   V9329 = "M6-10 AGE 3RD OLD KID-HD"
   V9330 = "M6-10 TOT # CHILDREN-HD"
   V9331 = "M6-10 # KIDS BY 25-HD"
   V9332 = "M11 # SIBLINGS-HD"
   V9333 = "M12 WTR OLDER SIBS-HD"
   V9334 = "M13 GREW UP FARM OR-HD"
   V9335 = "M14-15 STATE GREW UP-HD"
   V9336 = "M14-15 CNTY GREW UP-HD"
   V9337 = "M14-16 #REGIONS LIVED-HD"
   V9338 = "M14-16 #STATES LIVED-HD"
   V9339 = "M17 EVER MOVE FOR JOB?HD"
   V9340 = "M18 NOT MOVED FOR JOB?HD"
   V9341 = "M19 PARENTS POOR OR?-HD"
   V9342 = "M20-21 EDUC OF FATHER-H"
   V9343 = "M22-23 EDUC OF MOTHER-H"
   V9344 = "M24 WTR VETERAN-HD"
   V9345 = "M25 #YRS WRKD SINCE 18-H"
   V9346 = "M26 #YRS WRKD FULLTIME-H"
   V9347 = "M27 P TIME WORKED-HD"
   V9348 = "M27 ACC P TIME WORKED-HD"
   V9349 = "M28 EDUCATION-HD"
   V9350 = "M29 WTR OTR TRAINING-HD"
   V9351 = "M30 TYPE OTR TRAINING-HD"
   V9352 = "M31 TROUBLE READING?-HD"
   V9353 = "M32 WTR OTR TRAINING-HD"
   V9354 = "M33 TYPE OTR SCHOOLING-H"
   V9355 = "M35 WTR BA/BS DEGREE-HD"
   V9356 = "M36 WTR ADVANCED DEG-HD"
   V9357 = "M37 RECORD RELIG PREF?HD"
   V9358 = "M38-39 RELIGIOUS PREF-HD"
   V9359 = "TN1 WHO RESPONDENT?"
   V9360 = "TN2 # OF INTERVWR CALLS"
   V9361 = "# OF INDIVIDUAL RECORDS"
   V9362 = "H+W 1982 FED TAXES"
   V9363 = "H+W 82 MARGINAL TAX RATE"
   V9364 = "1ST XTRA ERNER 82 TAXES"
   V9365 = "MARG TAX RATE ERNR ONE"
   V9366 = "2ND XTRA ERNER 82 TAXES"
   V9367 = "MARG TAX RATE ERNR TWO"
   V9368 = "3RD XTRA ERNER 82 TAXES"
   V9369 = "MARG TAX RATE ERNR THREE"
   V9370 = "4TH XTRA ERNER 82 TAXES"
   V9371 = "MARG TAX RATE ERNR FOUR"
   V9372 = "5TH XTRA ERNER 82 TAXES"
   V9373 = "MARG TAX RATE ERNR FIVE"
   V9374 = "TOT TAXES ALL XTRA ERNR"
   V9375 = "TOT FAM MONEY Y 82"
   V9376 = "TOTAL HEAD LABOR Y 82"
   V9377 = "1982 TOT FAM Y/NEEDS"
   V9378 = "ANNUAL FOOD STD"
   V9379 = "HEAD 82 AVG HRLY EARNING"
   V9380 = "WIFE 82 AVG HRLY EARNING"
   V9381 = "REGION OF 1983 INTERVIEW"
   V9382 = "REGION 83 HD GREW UP"
   V9383 = "REGION 83 HD FA GREW UP"
   V9384 = "REGION 83 HD MO GREW UP"
   V9385 = "GEOGRAPHIC MOBILITY"
   V9386 = "ACC 82 Y COMPONENTS"
   V9387 = "# MINOR ASSGMTS IN 83"
   V9388 = "# MAJOR ASSGMTS IN 83"
   V9389 = "DU VALUE/ROOM - 1983"
   V9390 = "ACTUL MINUS REQ ROOMS 83"
   V9391 = "PERSON/ROOM IN 1983"
   V9392 = "# 18 OR OLDER IN 83"
   V9393 = "BKT AGE HEAD 1983"
   V9394 = "BKT AGE WIFE 1983"
   V9395 = "EDUCATION 1983 HEAD"
   V9396 = "EDUCATION 1983 WIFE"
   V9397 = "DECILE: 82 TOT FAM Y"
   V9398 = "DECILE: 82 Y/NEEDS"
   V9399 = "# CHILDREN AGE 1-2"
   V9400 = "# CHILDREN AGE 3-5"
   V9401 = "# CHILDREN AGE 6-13"
   V9402 = "# FEM CHILDREN AGE 14-17"
   V9403 = "# MALE CHILDREN 14-17"
   V9404 = "# FEM CHILDREN 18-20"
   V9405 = "# MALE CHILDREN 18-20"
   V9406 = "# FEM CHILDREN 21-29"
   V9407 = "# MALE CHILDREN 21-29"
   V9408 = "RACE (FROM 1972)"
   V9409 = "SPLIT SAMPLE FILTER"
   V9410 = "SAMP ERR COMP UNIT(SECU)"
   V9411 = "BRR STRATUM"
   V9412 = "BRR SECU"
   V9413 = "PSALMS STRATUM"
   V9414 = "PSALMS SECU"
   V9415 = "UNSKL M CNTY LABOR SUPPL"
   V9416 = "TYPICAL UNSKL WAGE RATE"
   V9417 = "1983 CNTY UNEMP RATE"
   V9418 = "16YR FAM COMP CHANGE"
   V9419 = "MARITAL STATUS 1983"
   V9420 = "82-83 CNG MARITAL STATUS"
   V9421 = "COUPLE STATUS OF HEAD"
   V9422 = "YR NEW HEAD IN FU"
   V9423 = "YR NEW WIFE IN FU"
   V9424 = "HD-SPOUSE SAMPLE STATUS"
   V9425 = "# 83 S/O FROM THIS FAM"
   V9426 = "83 MAIN FAM ID FOR S/0"
   V9427 = "83ID OF 1ST OTR FU IN HU"
   V9428 = "REL OF 1ST OTHER FU"
   V9429 = "83ID OF 2ND OTR FU IN HU"
   V9430 = "REL OF 2ND OTHER FU"
   V9431 = "83ID OF 3RD OTR FU IN HU"
   V9432 = "REL OF 3RD OTHER FU"
   V9433 = "1983 FAMILY WEIGHT";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V8803=99 THEN V8803=.;
IF V8804=999 THEN V8804=.;
IF V8805=99999 THEN V8805=.;
IF V8806=9 THEN V8806=.;
IF V8808=9 THEN V8808=.;
IF V8809=9 THEN V8809=.;
IF V8829=9999 THEN V8829=.;
IF V8861=9 THEN V8861=.;
IF V8870=99 THEN V8870=.;
IF V8892=99999 THEN V8892=.;
IF V8958=9999 THEN V8958=.;
IF V8959=999 THEN V8959=.;
IF V8961=99 THEN V8961=.;
IF V8963=99 THEN V8963=.;
IF V8965=99 THEN V8965=.;
IF V8966=9 THEN V8966=.;
IF V8967=9 THEN V8967=.;
IF V8968=99999 THEN V8968=.;
IF V8969=9 THEN V8969=.;
IF V8970=9 THEN V8970=.;
IF V8971=99 THEN V8971=.;
IF V8973=9 THEN V8973=.;
IF V8975=9 THEN V8975=.;
IF V8976=99 THEN V8976=.;
IF V8977=9 THEN V8977=.;
IF V8978=9 THEN V8978=.;
IF V8979=9 THEN V8979=.;
IF V8980=9 THEN V8980=.;
IF V8981=9999 THEN V8981=.;
IF V8983=9 THEN V8983=.;
IF V8984=9 THEN V8984=.;
IF V8985=9 THEN V8985=.;
IF V8986=9999 THEN V8986=.;
IF V8988=9 THEN V8988=.;
IF V8989=9999 THEN V8989=.;
IF V8991=9 THEN V8991=.;
IF V8992=9999 THEN V8992=.;
IF V8994=9 THEN V8994=.;
IF V8995=9999 THEN V8995=.;
IF V8997=9 THEN V8997=.;
IF V8998=9999 THEN V8998=.;
IF V8999=9 THEN V8999=.;
IF V9000=99 THEN V9000=.;
IF V9001=9 THEN V9001=.;
IF V9002=9 THEN V9002=.;
IF V9003=9 THEN V9003=.;
IF V9004=9 THEN V9004=.;
IF V9006=9 THEN V9006=.;
IF V9007=9 THEN V9007=.;
IF V9008=9 THEN V9008=.;
IF V9009=9 THEN V9009=.;
IF V9010=999 THEN V9010=.;
IF V9011=999 THEN V9011=.;
IF V9012=999 THEN V9012=.;
IF V9013=9 THEN V9013=.;
IF V9014=9999 THEN V9014=.;
IF V9015=9 THEN V9015=.;
IF V9016=9999 THEN V9016=.;
IF V9017=9999 THEN V9017=.;
IF V9018=9999 THEN V9018=.;
IF V9019=9 THEN V9019=.;
IF V9020=9999 THEN V9020=.;
IF V9021=999 THEN V9021=.;
IF V9022=9 THEN V9022=.;
IF V9023=9 THEN V9023=.;
IF V9024=9 THEN V9024=.;
IF V9025=99 THEN V9025=.;
IF V9026=9 THEN V9026=.;
IF V9027=99 THEN V9027=.;
IF V9028=9 THEN V9028=.;
IF V9029=99 THEN V9029=.;
IF V9030=9 THEN V9030=.;
IF V9031=99 THEN V9031=.;
IF V9032=9 THEN V9032=.;
IF V9033=99 THEN V9033=.;
IF V9034=99 THEN V9034=.;
IF V9035=99 THEN V9035=.;
IF V9036=9 THEN V9036=.;
IF V9037=9 THEN V9037=.;
IF V9038=99 THEN V9038=.;
IF V9039=9 THEN V9039=.;
IF V9040=9999 THEN V9040=.;
IF V9041=99 THEN V9041=.;
IF V9042=99 THEN V9042=.;
IF V9043=99 THEN V9043=.;
IF V9044=99 THEN V9044=.;
IF V9045=999 THEN V9045=.;
IF V9046=9 THEN V9046=.;
IF V9047=9 THEN V9047=.;
IF V9048=9 THEN V9048=.;
IF V9049=9 THEN V9049=.;
IF V9050=9 THEN V9050=.;
IF V9051=99 THEN V9051=.;
IF V9052=99 THEN V9052=.;
IF V9053=999 THEN V9053=.;
IF V9054=9 THEN V9054=.;
IF V9055=9 THEN V9055=.;
IF V9056=9 THEN V9056=.;
IF V9057=9 THEN V9057=.;
IF V9058=9 THEN V9058=.;
IF V9059=99 THEN V9059=.;
IF V9060=99 THEN V9060=.;
IF V9061=999 THEN V9061=.;
IF V9062=9 THEN V9062=.;
IF V9063=9 THEN V9063=.;
IF V9064=9 THEN V9064=.;
IF V9065=9 THEN V9065=.;
IF V9066=9 THEN V9066=.;
IF V9067=9 THEN V9067=.;
IF V9068=99 THEN V9068=.;
IF V9069=9 THEN V9069=.;
IF V9070=99 THEN V9070=.;
IF V9072=9 THEN V9072=.;
IF V9073=99 THEN V9073=.;
IF V9075=9 THEN V9075=.;
IF V9076=9 THEN V9076=.;
IF V9077=9 THEN V9077=.;
IF V9078=9 THEN V9078=.;
IF V9079=9999 THEN V9079=.;
IF V9080=9 THEN V9080=.;
IF V9081=9 THEN V9081=.;
IF V9082=9 THEN V9082=.;
IF V9083=9 THEN V9083=.;
IF V9084=9 THEN V9084=.;
IF V9087=99 THEN V9087=.;
IF V9088=9 THEN V9088=.;
IF V9089=9 THEN V9089=.;
IF V9090=9 THEN V9090=.;
IF V9091=9 THEN V9091=.;
IF V9092=99 THEN V9092=.;
IF V9093=9 THEN V9093=.;
IF V9094=9 THEN V9094=.;
IF V9095=9 THEN V9095=.;
IF V9096=9 THEN V9096=.;
IF V9097=99 THEN V9097=.;
IF V9098=99 THEN V9098=.;
IF V9099=9 THEN V9099=.;
IF V9100=9 THEN V9100=.;
IF V9101=9 THEN V9101=.;
IF V9102=9999 THEN V9102=.;
IF V9103=99 THEN V9103=.;
IF V9104=9 THEN V9104=.;
IF V9105=999 THEN V9105=.;
IF V9106=999 THEN V9106=.;
IF V9107=9 THEN V9107=.;
IF V9108=99 THEN V9108=.;
IF V9109=9 THEN V9109=.;
IF V9110=99 THEN V9110=.;
IF V9111=9 THEN V9111=.;
IF V9112=99 THEN V9112=.;
IF V9113=9 THEN V9113=.;
IF V9114=99 THEN V9114=.;
IF V9115=9 THEN V9115=.;
IF V9116=99 THEN V9116=.;
IF V9117=9 THEN V9117=.;
IF V9118=99 THEN V9118=.;
IF V9119=99 THEN V9119=.;
IF V9120=99 THEN V9120=.;
IF V9121=9 THEN V9121=.;
IF V9122=99 THEN V9122=.;
IF V9123=9 THEN V9123=.;
IF V9124=9999 THEN V9124=.;
IF V9125=99 THEN V9125=.;
IF V9126=99 THEN V9126=.;
IF V9127=99 THEN V9127=.;
IF V9128=99 THEN V9128=.;
IF V9129=999 THEN V9129=.;
IF V9130=9 THEN V9130=.;
IF V9131=9 THEN V9131=.;
IF V9132=9 THEN V9132=.;
IF V9133=9 THEN V9133=.;
IF V9134=9 THEN V9134=.;
IF V9135=99 THEN V9135=.;
IF V9136=99 THEN V9136=.;
IF V9137=999 THEN V9137=.;
IF V9138=9 THEN V9138=.;
IF V9139=9 THEN V9139=.;
IF V9140=9 THEN V9140=.;
IF V9141=9 THEN V9141=.;
IF V9142=9 THEN V9142=.;
IF V9143=99 THEN V9143=.;
IF V9144=99 THEN V9144=.;
IF V9145=999 THEN V9145=.;
IF V9146=9 THEN V9146=.;
IF V9147=9 THEN V9147=.;
IF V9148=9 THEN V9148=.;
IF V9149=9 THEN V9149=.;
IF V9150=9 THEN V9150=.;
IF V9151=9 THEN V9151=.;
IF V9152=99 THEN V9152=.;
IF V9153=9 THEN V9153=.;
IF V9154=99 THEN V9154=.;
IF V9156=9 THEN V9156=.;
IF V9157=99 THEN V9157=.;
IF V9159=9 THEN V9159=.;
IF V9160=9 THEN V9160=.;
IF V9161=9 THEN V9161=.;
IF V9164=99 THEN V9164=.;
IF V9165=9 THEN V9165=.;
IF V9166=9 THEN V9166=.;
IF V9167=99 THEN V9167=.;
IF V9168=9 THEN V9168=.;
IF V9169=9 THEN V9169=.;
IF V9170=9 THEN V9170=.;
IF V9171=9 THEN V9171=.;
IF V9172=99 THEN V9172=.;
IF V9174=99 THEN V9174=.;
IF V9175=9 THEN V9175=.;
IF V9176=999 THEN V9176=.;
IF V9177=999 THEN V9177=.;
IF V9178=99 THEN V9178=.;
IF V9179=99 THEN V9179=.;
IF V9180=9 THEN V9180=.;
IF V9181=9 THEN V9181=.;
IF V9182=9 THEN V9182=.;
IF V9183=99 THEN V9183=.;
IF V9184=9 THEN V9184=.;
IF V9185=9 THEN V9185=.;
IF V9186=9 THEN V9186=.;
IF V9189=9 THEN V9189=.;
IF V9190=9 THEN V9190=.;
IF V9191=9 THEN V9191=.;
IF V9192=9 THEN V9192=.;
IF V9193=999 THEN V9193=.;
IF V9194=999 THEN V9194=.;
IF V9195=999 THEN V9195=.;
IF V9196=9 THEN V9196=.;
IF V9197=9999 THEN V9197=.;
IF V9198=9999 THEN V9198=.;
IF V9199=9 THEN V9199=.;
IF V9200=999 THEN V9200=.;
IF V9201=9 THEN V9201=.;
IF V9202=9 THEN V9202=.;
IF V9203=99 THEN V9203=.;
IF V9204=9 THEN V9204=.;
IF V9205=99 THEN V9205=.;
IF V9206=9 THEN V9206=.;
IF V9207=99 THEN V9207=.;
IF V9208=9 THEN V9208=.;
IF V9209=99 THEN V9209=.;
IF V9210=9 THEN V9210=.;
IF V9211=99 THEN V9211=.;
IF V9212=99 THEN V9212=.;
IF V9213=99 THEN V9213=.;
IF V9214=9 THEN V9214=.;
IF V9215=9 THEN V9215=.;
IF V9216=99 THEN V9216=.;
IF V9217=99 THEN V9217=.;
IF V9218=99 THEN V9218=.;
IF V9221=99 THEN V9221=.;
IF V9222=9 THEN V9222=.;
IF V9223=9 THEN V9223=.;
IF V9224=99 THEN V9224=.;
IF V9225=9 THEN V9225=.;
IF V9226=9 THEN V9226=.;
IF V9227=9 THEN V9227=.;
IF V9228=99 THEN V9228=.;
IF V9229=99 THEN V9229=.;
IF V9230=9 THEN V9230=.;
IF V9231=9 THEN V9231=.;
IF V9232=99 THEN V9232=.;
IF V9233=9 THEN V9233=.;
IF V9234=999 THEN V9234=.;
IF V9235=999 THEN V9235=.;
IF V9236=9 THEN V9236=.;
IF V9237=99 THEN V9237=.;
IF V9238=9 THEN V9238=.;
IF V9239=99 THEN V9239=.;
IF V9240=9 THEN V9240=.;
IF V9241=99 THEN V9241=.;
IF V9242=9 THEN V9242=.;
IF V9243=99 THEN V9243=.;
IF V9244=9 THEN V9244=.;
IF V9245=99 THEN V9245=.;
IF V9246=9 THEN V9246=.;
IF V9247=99 THEN V9247=.;
IF V9248=99 THEN V9248=.;
IF V9249=99 THEN V9249=.;
IF V9250=9 THEN V9250=.;
IF V9251=99 THEN V9251=.;
IF V9252=99 THEN V9252=.;
IF V9253=99 THEN V9253=.;
IF V9256=99 THEN V9256=.;
IF V9257=9 THEN V9257=.;
IF V9258=9 THEN V9258=.;
IF V9259=99 THEN V9259=.;
IF V9260=9 THEN V9260=.;
IF V9261=9 THEN V9261=.;
IF V9262=9 THEN V9262=.;
IF V9263=99 THEN V9263=.;
IF V9265=99 THEN V9265=.;
IF V9266=9 THEN V9266=.;
IF V9267=999 THEN V9267=.;
IF V9268=999 THEN V9268=.;
IF V9269=99 THEN V9269=.;
IF V9270=99 THEN V9270=.;
IF V9271=9 THEN V9271=.;
IF V9272=9 THEN V9272=.;
IF V9273=9 THEN V9273=.;
IF V9274=9 THEN V9274=.;
IF V9275=9 THEN V9275=.;
IF V9276=9 THEN V9276=.;
IF V9277=9 THEN V9277=.;
IF V9278=9 THEN V9278=.;
IF V9280=99 THEN V9280=.;
IF V9281=99 THEN V9281=.;
IF V9283=9 THEN V9283=.;
IF V9284=9 THEN V9284=.;
IF V9285=9 THEN V9285=.;
IF V9286=9 THEN V9286=.;
IF V9287=99999 THEN V9287=.;
IF V9288=9 THEN V9288=.;
IF V9289=9 THEN V9289=.;
IF V9290=9 THEN V9290=.;
IF V9291=9 THEN V9291=.;
IF V9292=9 THEN V9292=.;
IF V9293=999 THEN V9293=.;
IF V9295=9 THEN V9295=.;
IF V9296=9 THEN V9296=.;
IF V9297=9 THEN V9297=.;
IF V9298=999 THEN V9298=.;
IF V9299=9 THEN V9299=.;
IF V9300=9 THEN V9300=.;
IF V9301=9 THEN V9301=.;
IF V9302=99999 THEN V9302=.;
IF V9303=9 THEN V9303=.;
IF V9304=9 THEN V9304=.;
IF V9305=9 THEN V9305=.;
IF V9306=9 THEN V9306=.;
IF V9308=99 THEN V9308=.;
IF V9309=9 THEN V9309=.;
IF V9310=9 THEN V9310=.;
IF V9311=9 THEN V9311=.;
IF V9312=9 THEN V9312=.;
IF V9313=9 THEN V9313=.;
IF V9314=9 THEN V9314=.;
IF V9315=99 THEN V9315=.;
IF V9316=99 THEN V9316=.;
IF V9320=99 THEN V9320=.;
IF V9321=999 THEN V9321=.;
IF V9322=99 THEN V9322=.;
IF V9323=999 THEN V9323=.;
IF V9324=9 THEN V9324=.;
IF V9325=9 THEN V9325=.;
IF V9326=9 THEN V9326=.;
IF V9327=99 THEN V9327=.;
IF V9328=99 THEN V9328=.;
IF V9329=99 THEN V9329=.;
IF V9330=99 THEN V9330=.;
IF V9331=9 THEN V9331=.;
IF V9332=9 THEN V9332=.;
IF V9333=9 THEN V9333=.;
IF V9334=9 THEN V9334=.;
IF V9335=99 THEN V9335=.;
IF V9336=999 THEN V9336=.;
IF V9337=9 THEN V9337=.;
IF V9338=9 THEN V9338=.;
IF V9339=9 THEN V9339=.;
IF V9340=9 THEN V9340=.;
IF V9341=9 THEN V9341=.;
IF V9342=9 THEN V9342=.;
IF V9343=9 THEN V9343=.;
IF V9344=9 THEN V9344=.;
IF V9345=99 THEN V9345=.;
IF V9346=99 THEN V9346=.;
IF V9349=99 THEN V9349=.;
IF V9350=9 THEN V9350=.;
IF V9351=9 THEN V9351=.;
IF V9352=9 THEN V9352=.;
IF V9353=9 THEN V9353=.;
IF V9354=9 THEN V9354=.;
IF V9355=9 THEN V9355=.;
IF V9356=9 THEN V9356=.;
IF V9357=9 THEN V9357=.;
IF V9358=9 THEN V9358=.;
IF V9359=9 THEN V9359=.;
IF V9360=9 THEN V9360=.;
IF V9381=9 THEN V9381=.;
IF V9382=9 THEN V9382=.;
IF V9383=9 THEN V9383=.;
IF V9384=9 THEN V9384=.;
IF V9385=9 THEN V9385=.;
IF V9389=99999 THEN V9389=.;
IF V9390=9 THEN V9390=.;
IF V9391=9.9 THEN V9391=.;
IF V9393=9 THEN V9393=.;
IF V9394=9 THEN V9394=.;
IF V9395=9 THEN V9395=.;
IF V9396=9 THEN V9396=.;
IF V9408=9 THEN V9408=.;
IF V9415=9 THEN V9415=.;
IF V9416=9999 THEN V9416=.;
IF V9417=99 THEN V9417=.;
 
file rawdat lrecl=1312;
put    
v8802
v8810
v8817
v8818
v8819
v8825
v8826
v8830
v8831
v8832
v8834
v8840
v8841
v8842
v8844
v8854
v8862
v8863
v8864
v8865
v8866
v8867
v8868
v8869
v8879
v8881
v8882
v8887
v8889
v8891
v8909
v8925
v8926
v8928
v8939
v8958
v8960
v8961
v8962
v8963
v8967
v8974
v8975
v8976
v8977
v8998
v8999
v9000
v9001
v9005
v9006
v9010
v9022
v9034
v9035
v9103
v9107
v9119
v9120
v9188
v9189
v9193
v9201
v9212
v9213
v9232
v9236
v9248
v9249
v9271
v9290
v9302
v9304
v9308
v9311
v9319
v9349
v9355
v9362
v9363
v9374
v9375
v9376
v9381
v9386
v9395
v9396
v9408
v9419
v9433
v30415
;

 proc means;
 run; 
